/*****************************************************************************
 *   qei.h:  Header file for NXP LPC29xx Family Microprocessors
 *
 *   Copyright(C) 2009, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2009.12.17  ver 1.00    Preliminary version, first Release
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/

#ifndef __QEI_H
#define __QEI_H

#define QEI_OFFSET	(1738) //1891 //(113+1778)	//113+1778		// Offset ticks from V4 + 30 degrees from SVM offset
#define QEI_CNTS   	(2000-1)	// Ticks per revolution	
#define QEI_LOAD 	1000 	 
#define QEI_CLK		10000	

#define QEI_INVINX 	(1<<3)		// Invert Index. When set, inverts the sense of the index input. 
#define QEI_CAPMODE	(1<<2)		// Capture Mode. When = 0, only PhA edges are counted (2X). When = 1, 
								// BOTH PhA and PhB edges are counted (4X), increasing	 resolution but decreasing range.
#define QEI_SIGMODE (1<<2)		// Signal Mode. When = 0, PhA and PhB function as quadrature encoder inputs. When = 1, 
								// PhA functions as the direction signal and PhB functions as the clock signal.
#define QEI_DIRINV 	(1<<0)		// Direction invert. When = 1, complements the DIR bit. 


#define QEIDirection 	QEISTAT & (1<<0)
#define QEIPosition		QEIPOS
#define QEIVelocity		QEICAP
#define QEIRPM			(QEI_CLK * QEICAP * 60) / (QEI_LOAD * QEI_CNTS * 4)
// clock is the controller clock rate
// ppr is the number of pulses per revolution of the physical encoder
// edges is 2 or 4, based on the capture mode set in the QEICON register (2 for
// CapMode set to 0 and 4 for CapMode set to 1)

extern volatile BYTE qei_index;

extern void INIT_QEI(void);
void QEIHandler(void);

#endif
